function [pval,critval]=augdfcv(tstat,p,T)
% Dickey-Fuller and Augmented Dickey Fuller critical values
%
% USAGE:
%  [PVAL,CRITVAL] = augdfcv(TSTAT,P,T)
%
% INPUTS:
%  TSTAT     - T-stat from ADF regression
%  P         - Order of the polynomial of include in the ADF regression:
%                0 : No determiniistic terms
%                1 : Constant
%                2 : Time Trend
%                3 : Constant, DGP assumed to have a time trend
%  T         - Length of the adjusted time series
%
% OUTPUTS:
%  PVAL      - Probability the series is a unit root
%  CRITVALS  - A 6 by 1 vector with the [.01 .05 .1 .9 .95 .99] values from
%               the DF distribution
%
% COMMENTS:
%  Simulated from 2,000,000 replications with gaussian errors.
%

% Copyright: Kevin Sheppard
% kevin.sheppard@economics.ox.ac.uk
% Revision: 3.0.1    Date: 1/1/2007




augdf_case1_cv=...
    [-4.52142	-3.69309	-3.49901	-3.38213	-3.33044	-3.28343	-3.29306	-3.28315	-3.29510	-3.29876
    -3.54498	-3.05867	-2.92581	-2.86348	-2.82403	-2.80403	-2.80166	-2.79858	-2.80102	-2.79722
    -3.14328	-2.76860	-2.66924	-2.61596	-2.58442	-2.57383	-2.56818	-2.56557	-2.56386	-2.56356
    -2.73568	-2.46496	-2.39025	-2.35064	-2.32987	-2.32355	-2.31648	-2.31121	-2.31161	-2.31058
    -2.49631	-2.28060	-2.21876	-2.18684	-2.16783	-2.16410	-2.15802	-2.15189	-2.15323	-2.15213
    -2.32866	-2.14256	-2.09373	-2.06320	-2.04729	-2.04421	-2.03982	-2.03485	-2.03540	-2.03353
    -2.19713	-2.03395	-1.99128	-1.96256	-1.94958	-1.94843	-1.94479	-1.93972	-1.94046	-1.93880
    -2.08778	-1.94320	-1.90488	-1.87838	-1.86815	-1.86743	-1.86421	-1.86013	-1.85938	-1.85752
    -1.99313	-1.86501	-1.83010	-1.80656	-1.79572	-1.79555	-1.79312	-1.78747	-1.78818	-1.78765
    -1.91099	-1.79497	-1.76399	-1.74196	-1.73303	-1.73069	-1.72868	-1.72399	-1.72572	-1.72508
    -1.83860	-1.73265	-1.70411	-1.68312	-1.67581	-1.67293	-1.67085	-1.66646	-1.66875	-1.66827
    -1.77261	-1.67441	-1.64778	-1.62919	-1.62332	-1.62025	-1.61801	-1.61381	-1.61679	-1.61628
    -1.71243	-1.62205	-1.59712	-1.57988	-1.57464	-1.57054	-1.56833	-1.56547	-1.56806	-1.56785
    -1.65643	-1.57286	-1.54990	-1.53332	-1.52947	-1.52535	-1.52356	-1.52039	-1.52216	-1.52306
    -1.60419	-1.52729	-1.50523	-1.49080	-1.48689	-1.48314	-1.48025	-1.47759	-1.47952	-1.48047
    -1.55575	-1.48375	-1.46372	-1.44985	-1.44590	-1.44272	-1.43988	-1.43769	-1.43919	-1.44026
    -1.50985	-1.44280	-1.42404	-1.41118	-1.40811	-1.40431	-1.40154	-1.39983	-1.40151	-1.40141
    -1.46742	-1.40302	-1.38597	-1.37369	-1.37160	-1.36785	-1.36538	-1.36369	-1.36509	-1.36513
    -1.42587	-1.36573	-1.35040	-1.33840	-1.33643	-1.33304	-1.33062	-1.32878	-1.33045	-1.33040
    -1.38614	-1.32989	-1.31568	-1.30471	-1.30271	-1.29916	-1.29765	-1.29592	-1.29713	-1.29710
    -1.34842	-1.29528	-1.28230	-1.27282	-1.27104	-1.26763	-1.26538	-1.26365	-1.26463	-1.26483
    -1.31215	-1.26268	-1.24925	-1.24104	-1.23912	-1.23648	-1.23405	-1.23235	-1.23306	-1.23397
    -1.27705	-1.23080	-1.21822	-1.21062	-1.20857	-1.20609	-1.20367	-1.20201	-1.20287	-1.20411
    -1.24334	-1.19999	-1.18798	-1.18094	-1.17864	-1.17661	-1.17456	-1.17307	-1.17300	-1.17482
    -1.21061	-1.16966	-1.15883	-1.15191	-1.15000	-1.14848	-1.14621	-1.14499	-1.14427	-1.14582
    -1.17815	-1.14082	-1.12997	-1.12354	-1.12212	-1.12067	-1.11830	-1.11743	-1.11679	-1.11802
    -1.14802	-1.11234	-1.10250	-1.09633	-1.09493	-1.09323	-1.09122	-1.09032	-1.08938	-1.09093
    -1.11813	-1.08418	-1.07529	-1.06922	-1.06835	-1.06707	-1.06462	-1.06397	-1.06296	-1.06444
    -1.08884	-1.05689	-1.04863	-1.04281	-1.04205	-1.04088	-1.03863	-1.03801	-1.03748	-1.03845
    -1.06019	-1.02998	-1.02278	-1.01738	-1.01617	-1.01573	-1.01273	-1.01301	-1.01195	-1.01257
    -1.03236	-1.00380	-0.99699	-0.99187	-0.99094	-0.99036	-0.98783	-0.98771	-0.98664	-0.98748
    -1.00486	-0.97834	-0.97159	-0.96758	-0.96631	-0.96567	-0.96300	-0.96329	-0.96170	-0.96294
    -0.97786	-0.95279	-0.94660	-0.94326	-0.94192	-0.94149	-0.93861	-0.93920	-0.93713	-0.93861
    -0.95165	-0.92774	-0.92217	-0.91945	-0.91799	-0.91730	-0.91448	-0.91548	-0.91316	-0.91444
    -0.92531	-0.90337	-0.89834	-0.89524	-0.89440	-0.89359	-0.89102	-0.89183	-0.88968	-0.89067
    -0.89981	-0.87913	-0.87409	-0.87181	-0.87038	-0.86999	-0.86758	-0.86839	-0.86658	-0.86724
    -0.87420	-0.85547	-0.85026	-0.84811	-0.84701	-0.84641	-0.84399	-0.84529	-0.84381	-0.84387
    -0.84906	-0.83164	-0.82673	-0.82475	-0.82399	-0.82333	-0.82100	-0.82256	-0.82069	-0.82058
    -0.82389	-0.80775	-0.80356	-0.80156	-0.80085	-0.80020	-0.79826	-0.79977	-0.79789	-0.79741
    -0.79871	-0.78461	-0.78023	-0.77882	-0.77817	-0.77709	-0.77558	-0.77684	-0.77530	-0.77462
    -0.77409	-0.76095	-0.75708	-0.75598	-0.75530	-0.75433	-0.75342	-0.75345	-0.75304	-0.75190
    -0.74915	-0.73741	-0.73451	-0.73324	-0.73200	-0.73156	-0.73075	-0.73063	-0.73054	-0.72929
    -0.72363	-0.71379	-0.71143	-0.71022	-0.70932	-0.70909	-0.70842	-0.70785	-0.70820	-0.70647
    -0.69851	-0.69044	-0.68836	-0.68759	-0.68649	-0.68678	-0.68562	-0.68533	-0.68547	-0.68382
    -0.67233	-0.66677	-0.66523	-0.66460	-0.66404	-0.66342	-0.66297	-0.66240	-0.66258	-0.66169
    -0.64615	-0.64283	-0.64214	-0.64195	-0.64119	-0.64048	-0.64020	-0.63979	-0.64006	-0.63913
    -0.61969	-0.61885	-0.61861	-0.61881	-0.61818	-0.61727	-0.61734	-0.61719	-0.61689	-0.61640
    -0.59371	-0.59476	-0.59516	-0.59528	-0.59542	-0.59395	-0.59427	-0.59361	-0.59362	-0.59308
    -0.56641	-0.57041	-0.57149	-0.57170	-0.57184	-0.57029	-0.57103	-0.57030	-0.57009	-0.56977
    -0.53941	-0.54514	-0.54719	-0.54795	-0.54816	-0.54644	-0.54727	-0.54670	-0.54670	-0.54617
    -0.51125	-0.51940	-0.52266	-0.52340	-0.52448	-0.52223	-0.52346	-0.52287	-0.52278	-0.52222
    -0.48370	-0.49389	-0.49774	-0.49926	-0.50051	-0.49834	-0.49957	-0.49870	-0.49801	-0.49814
    -0.45536	-0.46788	-0.47290	-0.47412	-0.47595	-0.47393	-0.47535	-0.47387	-0.47370	-0.47365
    -0.42711	-0.44111	-0.44747	-0.44898	-0.45119	-0.44894	-0.45057	-0.44926	-0.44880	-0.44936
    -0.39828	-0.41514	-0.42126	-0.42326	-0.42600	-0.42369	-0.42548	-0.42410	-0.42361	-0.42418
    -0.36927	-0.38832	-0.39532	-0.39769	-0.40039	-0.39830	-0.39974	-0.39834	-0.39806	-0.39845
    -0.33984	-0.36076	-0.36896	-0.37139	-0.37436	-0.37211	-0.37397	-0.37262	-0.37218	-0.37268
    -0.31028	-0.33277	-0.34259	-0.34508	-0.34804	-0.34547	-0.34752	-0.34647	-0.34576	-0.34686
    -0.28085	-0.30528	-0.31578	-0.31830	-0.32175	-0.31875	-0.32098	-0.31987	-0.31923	-0.32028
    -0.25098	-0.27717	-0.28832	-0.29115	-0.29453	-0.29186	-0.29392	-0.29323	-0.29232	-0.29295
    -0.22083	-0.24853	-0.26085	-0.26424	-0.26731	-0.26499	-0.26693	-0.26578	-0.26486	-0.26632
    -0.19000	-0.21956	-0.23270	-0.23660	-0.23935	-0.23753	-0.23922	-0.23830	-0.23750	-0.23895
    -0.15926	-0.19041	-0.20450	-0.20812	-0.21134	-0.20976	-0.21150	-0.21080	-0.20944	-0.21133
    -0.12820	-0.16073	-0.17563	-0.17927	-0.18343	-0.18163	-0.18349	-0.18272	-0.18150	-0.18308
    -0.09674	-0.13131	-0.14673	-0.15026	-0.15420	-0.15389	-0.15503	-0.15476	-0.15305	-0.15444
    -0.06440	-0.10175	-0.11715	-0.12090	-0.12509	-0.12495	-0.12559	-0.12630	-0.12460	-0.12579
    -0.03216	-0.07122	-0.08765	-0.09137	-0.09652	-0.09629	-0.09699	-0.09690	-0.09520	-0.09696
    0.00046 	-0.04091	-0.05735	-0.06139	-0.06718	-0.06623	-0.06733	-0.06732	-0.06579	-0.06703
    0.03356 	-0.00949	-0.02646	-0.03120	-0.03739	-0.03621	-0.03674	-0.03772	-0.03559	-0.03742
    0.06752 	0.02220	   	 0.00481	-0.00054	-0.00708	-0.00608	-0.00618	-0.00736	-0.00495	-0.00638
    0.10242 	0.05430		 0.03632	0.03076		0.02420		0.02430		0.02520		0.02383		0.02568		0.02414
    0.13716 	0.08719		 0.06866	0.06214		0.05571		0.05541		0.05651		0.05465		0.05712		0.05565
    0.17226 	0.12001		 0.10121	0.09426		0.08725		0.08777		0.08866		0.08697		0.08892		0.08750
    0.20789 	0.15405		 0.13409	0.12686		0.11945		0.12014		0.12100		0.12017		0.12100		0.12006
    0.24432 	0.18799		 0.16817	0.16017		0.15280		0.15314		0.15386		0.15273		0.15407		0.15319
    0.28182 	0.22280		 0.20250	0.19428		0.18620		0.18660		0.18683		0.18641		0.18762		0.18698
    0.32002 	0.25874		 0.23721	0.22950		0.22057		0.22135		0.22088		0.21987		0.22162		0.22192
    0.35916 	0.29499		 0.27305	0.26515		0.25649		0.25638		0.25645		0.25477		0.25682		0.25658
    0.39979 	0.33235		 0.31042	0.30143		0.29263		0.29272		0.29269		0.29116		0.29313		0.29268
    0.44111 	0.37172		 0.34751	0.33896		0.32937		0.32942		0.32966		0.32797		0.33001		0.32894
    0.48374 	0.41100		 0.38627	0.37741		0.36760		0.36742		0.36807		0.36566		0.36793		0.36658
    0.52743 	0.45120		 0.42589	0.41641		0.40705		0.40742		0.40722		0.40466		0.40655		0.40519
    0.57294 	0.49269		 0.46726	0.45690		0.44736		0.44762		0.44728		0.44438		0.44629		0.44479
    0.62048 	0.53600		 0.50912	0.49870		0.48894		0.48930		0.48884		0.48596		0.48785		0.48600
    0.66913 	0.58156		 0.55290	0.54196		0.53213		0.53238		0.53151		0.52847		0.53030		0.52832
    0.72003 	0.62841		 0.59783	0.58667		0.57715		0.57649		0.57608		0.57317		0.57555		0.57299
    0.77304 	0.67871		 0.64502	0.63327		0.62321		0.62309		0.62173		0.61952		0.62164		0.62011
    0.82892 	0.72984		 0.69424	0.68233		0.67291		0.67089		0.67002		0.66788		0.67043		0.66908
    0.88852 	0.78287		 0.74612	0.73422		0.72420		0.72130		0.72101		0.71970		0.72106		0.72014
    0.95232 	0.83982		 0.80061	0.78812		0.77770		0.77497		0.77474		0.77386		0.77505		0.77309
    1.01924 	0.89998		 0.85925	0.84520		0.83406		0.83103		0.83123		0.83090		0.83060		0.82904
    1.09055 	0.96416		 0.92144	0.90691		0.89511		0.89037		0.89203		0.89112		0.89079		0.88905
    1.16910 	1.03389		 0.98858	0.97301		0.96037		0.95604		0.95539		0.95652		0.95616		0.95265
    1.25501 	1.11060		 1.06124	1.04555		1.03197		1.02658		1.02556		1.02730		1.02621		1.02252
    1.35066 	1.19418		 1.14227	1.12350		1.10982		1.10407		1.10291		1.10461		1.10191		1.09857
    1.45684 	1.28640		 1.23263	1.21002		1.19652		1.18976		1.18933		1.18986		1.18830		1.18470
    1.58203 	1.39385		 1.33357	1.31164		1.29541		1.28781		1.28772		1.28843		1.28530		1.28290
    1.73261 	1.52054		 1.45262	1.42716		1.41096		1.40242		1.40201		1.40272		1.40244		1.39725
    1.92372 	1.67825		 1.60230	1.57122		1.55373		1.54400		1.54364		1.54541		1.54040		1.53792
    2.18969 	1.88853		 1.80053	1.75929		1.74175		1.72787		1.72926		1.72845		1.72747		1.72380
    2.63993 	2.22647		 2.10964	2.06812		2.03721		2.02479		2.02421		2.01695		2.01200		2.01105
    3.08956 	2.54045		 2.39882	2.34679		2.30850		2.29174		2.28985		2.27455		2.27355		2.27516
    4.15865 	3.22529		 2.99776	2.92041		2.86400		2.85176		2.83694		2.81680		2.82806		2.83169];


augdf_case2_cv=...
    [-9.12908 -5.65100 -4.80169 -4.42177 -4.21885 -4.15360 -4.12049 -4.10719 -4.08486 -4.10178
    -6.83529 -4.67514 -4.13064 -3.86932 -3.73373 -3.68647 -3.66852 -3.65446 -3.64764 -3.65264
    -5.95372 -4.26761 -3.82721 -3.61933 -3.50700 -3.46278 -3.44937 -3.43865 -3.43428 -3.43343
    -5.14667 -3.86607 -3.51695 -3.35180 -3.26311 -3.23073 -3.21404 -3.20556 -3.20432 -3.20536
    -4.69647 -3.62354 -3.33068 -3.18884 -3.11142 -3.08397 -3.07027 -3.06074 -3.05967 -3.05837
    -4.38604 -3.45074 -3.19154 -3.06811 -2.99740 -2.97326 -2.96090 -2.95117 -2.95145 -2.94908
    -4.15026 -3.31444 -3.08270 -2.96932 -2.90423 -2.88350 -2.87392 -2.86365 -2.86453 -2.86249
    -3.96134 -3.20186 -2.99116 -2.88789 -2.82741 -2.80856 -2.79935 -2.79051 -2.78940 -2.78889
    -3.80096 -3.10640 -2.91203 -2.81628 -2.76073 -2.74322 -2.73468 -2.72613 -2.72534 -2.72440
    -3.66303 -3.02170 -2.84204 -2.75244 -2.70145 -2.68359 -2.67666 -2.66761 -2.66822 -2.66762
    -3.54478 -2.94637 -2.78001 -2.69508 -2.64785 -2.63059 -2.62449 -2.61543 -2.61606 -2.61541
    -3.43657 -2.87869 -2.72161 -2.64345 -2.59832 -2.58197 -2.57691 -2.56749 -2.56876 -2.56834
    -3.33848 -2.81800 -2.66872 -2.59408 -2.55172 -2.53747 -2.53182 -2.52267 -2.52384 -2.52438
    -3.24962 -2.76000 -2.61942 -2.54942 -2.50900 -2.49626 -2.49045 -2.48192 -2.48235 -2.48305
    -3.16862 -2.70628 -2.57297 -2.50707 -2.46897 -2.45774 -2.45192 -2.44334 -2.44423 -2.44402
    -3.09261 -2.65649 -2.53030 -2.46684 -2.43109 -2.42040 -2.41498 -2.40697 -2.40793 -2.40742
    -3.02242 -2.60959 -2.48969 -2.42926 -2.39491 -2.38454 -2.37946 -2.37229 -2.37373 -2.37289
    -2.95780 -2.56521 -2.45072 -2.39354 -2.36008 -2.35056 -2.34559 -2.33899 -2.34001 -2.33975
    -2.89545 -2.52320 -2.41414 -2.35927 -2.32728 -2.31817 -2.31371 -2.30735 -2.30817 -2.30758
    -2.83850 -2.48265 -2.37834 -2.32663 -2.29546 -2.28731 -2.28270 -2.27667 -2.27759 -2.27693
    -2.78250 -2.44417 -2.34409 -2.29522 -2.26491 -2.25688 -2.25271 -2.24708 -2.24784 -2.24688
    -2.73014 -2.40712 -2.31148 -2.26445 -2.23547 -2.22768 -2.22382 -2.21886 -2.21960 -2.21855
    -2.68028 -2.37081 -2.27985 -2.23492 -2.20677 -2.20022 -2.19605 -2.19140 -2.19167 -2.19114
    -2.63307 -2.33692 -2.24936 -2.20607 -2.17936 -2.17271 -2.16927 -2.16460 -2.16511 -2.16415
    -2.58685 -2.30363 -2.21999 -2.17847 -2.15275 -2.14619 -2.14294 -2.13864 -2.13870 -2.13820
    -2.54313 -2.27143 -2.19185 -2.15153 -2.12714 -2.12061 -2.11743 -2.11330 -2.11330 -2.11265
    -2.50042 -2.23975 -2.16417 -2.12491 -2.10221 -2.09553 -2.09246 -2.08846 -2.08887 -2.08795
    -2.45889 -2.20979 -2.13687 -2.09904 -2.07715 -2.07079 -2.06812 -2.06442 -2.06451 -2.06382
    -2.41901 -2.18031 -2.11022 -2.07392 -2.05283 -2.04685 -2.04443 -2.04103 -2.04157 -2.04027
    -2.38011 -2.15186 -2.08454 -2.04938 -2.02918 -2.02290 -2.02111 -2.01825 -2.01830 -2.01738
    -2.34323 -2.12343 -2.05914 -2.02459 -2.00608 -1.99988 -1.99841 -1.99493 -1.99540 -1.99453
    -2.30705 -2.09517 -2.03402 -2.00148 -1.98314 -1.97679 -1.97602 -1.97236 -1.97263 -1.97224
    -2.27185 -2.06820 -2.00991 -1.97813 -1.96067 -1.95454 -1.95387 -1.95069 -1.95070 -1.95038
    -2.23691 -2.04154 -1.98570 -1.95543 -1.93816 -1.93327 -1.93181 -1.92877 -1.92926 -1.92820
    -2.20347 -2.01558 -1.96185 -1.93260 -1.91645 -1.91183 -1.91011 -1.90714 -1.90756 -1.90686
    -2.17057 -1.98997 -1.93873 -1.91012 -1.89482 -1.89014 -1.88888 -1.88565 -1.88610 -1.88583
    -2.13871 -1.96455 -1.91574 -1.88826 -1.87362 -1.86894 -1.86810 -1.86463 -1.86495 -1.86496
    -2.10682 -1.93947 -1.89290 -1.86620 -1.85254 -1.84789 -1.84735 -1.84393 -1.84397 -1.84413
    -2.07582 -1.91516 -1.87053 -1.84493 -1.83151 -1.82727 -1.82662 -1.82339 -1.82373 -1.82371
    -2.04554 -1.89135 -1.84825 -1.82371 -1.81096 -1.80683 -1.80595 -1.80307 -1.80372 -1.80352
    -2.01538 -1.86752 -1.82608 -1.80280 -1.79082 -1.78664 -1.78548 -1.78297 -1.78364 -1.78341
    -1.98547 -1.84434 -1.80400 -1.78189 -1.77056 -1.76650 -1.76538 -1.76287 -1.76335 -1.76332
    -1.95651 -1.82118 -1.78216 -1.76149 -1.75020 -1.74674 -1.74536 -1.74279 -1.74358 -1.74333
    -1.92785 -1.79826 -1.76085 -1.74087 -1.73019 -1.72689 -1.72579 -1.72313 -1.72374 -1.72389
    -1.89906 -1.77520 -1.73968 -1.72066 -1.71045 -1.70715 -1.70598 -1.70346 -1.70425 -1.70439
    -1.87099 -1.75264 -1.71853 -1.70013 -1.69077 -1.68703 -1.68624 -1.68368 -1.68458 -1.68462
    -1.84330 -1.72983 -1.69792 -1.67964 -1.67099 -1.66726 -1.66650 -1.66423 -1.66492 -1.66533
    -1.81557 -1.70696 -1.67707 -1.65931 -1.65107 -1.64782 -1.64690 -1.64462 -1.64553 -1.64580
    -1.78778 -1.68515 -1.65582 -1.63900 -1.63090 -1.62840 -1.62723 -1.62535 -1.62624 -1.62652
    -1.76090 -1.66281 -1.63501 -1.61908 -1.61120 -1.60860 -1.60779 -1.60591 -1.60635 -1.60722
    -1.73404 -1.64035 -1.61385 -1.59846 -1.59135 -1.58872 -1.58800 -1.58665 -1.58676 -1.58776
    -1.70777 -1.61775 -1.59333 -1.57797 -1.57143 -1.56895 -1.56830 -1.56741 -1.56698 -1.56812
    -1.68162 -1.59587 -1.57262 -1.55760 -1.55184 -1.54920 -1.54891 -1.54793 -1.54752 -1.54843
    -1.65535 -1.57381 -1.55191 -1.53739 -1.53206 -1.52963 -1.52982 -1.52837 -1.52809 -1.52926
    -1.62892 -1.55163 -1.53094 -1.51706 -1.51229 -1.50995 -1.51025 -1.50901 -1.50808 -1.50983
    -1.60244 -1.52923 -1.51008 -1.49668 -1.49245 -1.49032 -1.49047 -1.48916 -1.48850 -1.49025
    -1.57638 -1.50722 -1.48914 -1.47603 -1.47230 -1.47033 -1.47035 -1.46927 -1.46882 -1.47071
    -1.55019 -1.48481 -1.46751 -1.45562 -1.45200 -1.45045 -1.45030 -1.44953 -1.44899 -1.45065
    -1.52378 -1.46236 -1.44640 -1.43505 -1.43207 -1.43005 -1.43020 -1.42950 -1.42907 -1.43070
    -1.49712 -1.43987 -1.42516 -1.41421 -1.41209 -1.40987 -1.40983 -1.40957 -1.40915 -1.41067
    -1.47027 -1.41740 -1.40356 -1.39335 -1.39170 -1.38939 -1.38942 -1.38908 -1.38896 -1.39013
    -1.44336 -1.39452 -1.38223 -1.37229 -1.37086 -1.36872 -1.36905 -1.36851 -1.36809 -1.36913
    -1.41614 -1.37129 -1.36045 -1.35125 -1.34972 -1.34791 -1.34803 -1.34792 -1.34768 -1.34828
    -1.38953 -1.34796 -1.33879 -1.32988 -1.32849 -1.32674 -1.32667 -1.32721 -1.32685 -1.32718
    -1.36213 -1.32411 -1.31644 -1.30796 -1.30744 -1.30537 -1.30498 -1.30574 -1.30532 -1.30580
    -1.33469 -1.29997 -1.29380 -1.28589 -1.28580 -1.28343 -1.28376 -1.28410 -1.28369 -1.28417
    -1.30659 -1.27579 -1.27052 -1.26341 -1.26394 -1.26158 -1.26166 -1.26215 -1.26181 -1.26220
    -1.27845 -1.25148 -1.24745 -1.24108 -1.24126 -1.23905 -1.23922 -1.23983 -1.23981 -1.23987
    -1.24921 -1.22646 -1.22375 -1.21871 -1.21841 -1.21638 -1.21693 -1.21692 -1.21690 -1.21743
    -1.21949 -1.20119 -1.19947 -1.19468 -1.19518 -1.19331 -1.19358 -1.19383 -1.19402 -1.19450
    -1.18971 -1.17509 -1.17500 -1.17018 -1.17177 -1.16954 -1.16989 -1.17028 -1.17043 -1.17085
    -1.15936 -1.14864 -1.14973 -1.14599 -1.14783 -1.14499 -1.14560 -1.14619 -1.14595 -1.14659
    -1.12799 -1.12134 -1.12376 -1.12105 -1.12286 -1.12030 -1.12093 -1.12156 -1.12110 -1.12188
    -1.09485 -1.09361 -1.09694 -1.09529 -1.09739 -1.09498 -1.09573 -1.09597 -1.09577 -1.09676
    -1.06151 -1.06483 -1.06944 -1.06898 -1.07101 -1.06880 -1.06946 -1.06999 -1.06987 -1.07108
    -1.02761 -1.03595 -1.04149 -1.04181 -1.04371 -1.04217 -1.04306 -1.04318 -1.04340 -1.04416
    -0.99266 -1.00655 -1.01315 -1.01384 -1.01553 -1.01473 -1.01560 -1.01553 -1.01655 -1.01648
    -0.95722 -0.97524 -0.98345 -0.98438 -0.98689 -0.98628 -0.98737 -0.98748 -0.98837 -0.98805
    -0.91943 -0.94290 -0.95279 -0.95481 -0.95744 -0.95699 -0.95762 -0.95841 -0.95880 -0.95874
    -0.88091 -0.90948 -0.92108 -0.92407 -0.92635 -0.92676 -0.92685 -0.92832 -0.92878 -0.92877
    -0.84167 -0.87502 -0.88766 -0.89163 -0.89454 -0.89540 -0.89509 -0.89741 -0.89738 -0.89755
    -0.80109 -0.83924 -0.85361 -0.85840 -0.86173 -0.86230 -0.86252 -0.86453 -0.86511 -0.86467
    -0.75888 -0.80264 -0.81937 -0.82347 -0.82753 -0.82824 -0.82906 -0.83059 -0.83132 -0.83111
    -0.71559 -0.76408 -0.78273 -0.78751 -0.79199 -0.79286 -0.79373 -0.79516 -0.79540 -0.79551
    -0.67089 -0.72476 -0.74501 -0.75005 -0.75517 -0.75557 -0.75705 -0.75801 -0.75945 -0.75896
    -0.62376 -0.68356 -0.70510 -0.70995 -0.71694 -0.71699 -0.71868 -0.71972 -0.72130 -0.72019
    -0.57389 -0.63976 -0.66328 -0.66871 -0.67615 -0.67694 -0.67834 -0.67970 -0.68041 -0.68024
    -0.52252 -0.59403 -0.61914 -0.62592 -0.63310 -0.63434 -0.63603 -0.63778 -0.63810 -0.63831
    -0.46814 -0.54636 -0.57350 -0.58087 -0.58727 -0.58941 -0.59099 -0.59262 -0.59380 -0.59328
    -0.41108 -0.49524 -0.52417 -0.53251 -0.53921 -0.54154 -0.54284 -0.54464 -0.54559 -0.54569
    -0.35096 -0.44171 -0.47080 -0.48239 -0.48803 -0.49063 -0.49142 -0.49414 -0.49470 -0.49555
    -0.28531 -0.38369 -0.41559 -0.42641 -0.43352 -0.43608 -0.43662 -0.43935 -0.43979 -0.44095
    -0.21744 -0.32080 -0.35552 -0.36651 -0.37404 -0.37756 -0.37848 -0.38077 -0.38135 -0.38291
    -0.14122 -0.25347 -0.28929 -0.30080 -0.31043 -0.31334 -0.31477 -0.31651 -0.31836 -0.31978
    -0.05662 -0.17946 -0.21675 -0.23007 -0.24064 -0.24306 -0.24468 -0.24700 -0.24698 -0.24950
    0.03840  -0.09470 -0.13533 -0.14974 -0.16212 -0.16453 -0.16535 -0.16821 -0.16862 -0.17105
    0.14714   0.00321 -0.04291 -0.05774 -0.07195 -0.07258 -0.07576 -0.07845 -0.07764 -0.08108
    0.28008   0.11498  0.06446  0.05087  0.03359  0.03242  0.02959  0.02628  0.02976  0.02672
    0.44175   0.25463  0.19898  0.18305  0.16394  0.16326  0.16280  0.15553  0.16092  0.15764
    0.66232   0.44552  0.38022  0.36367  0.33673  0.33802  0.33675  0.32903  0.33610  0.33028
    1.02705   0.74486  0.66849  0.64233  0.61699  0.61477  0.61228  0.60697  0.60908  0.60206
    1.39117   1.03262  0.92830  0.90399  0.86904  0.86469  0.86283  0.85700  0.85648  0.84867
    2.26432   1.63463  1.47377  1.43624  1.39435  1.39226  1.39292  1.36896  1.36113  1.36669 ];





augdf_case4_cv=...
    [-12.98315 -6.57479 -5.30727 -4.86368 -4.69109 -4.63791 -4.60870 -4.62039 -4.58927 -4.59356
    -9.51742 -5.43379 -4.63634 -4.35626 -4.23330 -4.18868 -4.16959 -4.16762 -4.16439 -4.16241
    -8.21474 -4.98803 -4.34430 -4.11486 -4.01150 -3.98194 -3.96781 -3.96094 -3.96044 -3.95935
    -7.02898 -4.54556 -4.04666 -3.86330 -3.78123 -3.75497 -3.74410 -3.73893 -3.73868 -3.73564
    -6.37599 -4.28751 -3.86484 -3.71107 -3.63834 -3.61358 -3.60288 -3.60040 -3.60025 -3.59838
    -5.93270 -4.10773 -3.73447 -3.59586 -3.53146 -3.50950 -3.49904 -3.49533 -3.49648 -3.49466
    -5.59836 -3.96534 -3.63084 -3.50359 -3.44393 -3.42583 -3.41549 -3.41181 -3.41135 -3.41186
    -5.33421 -3.84924 -3.54481 -3.42438 -3.37166 -3.35511 -3.34489 -3.33984 -3.34156 -3.34094
    -5.11315 -3.74981 -3.47111 -3.35729 -3.30795 -3.29220 -3.28361 -3.27893 -3.27958 -3.27955
    -4.92663 -3.66468 -3.40453 -3.29784 -3.25099 -3.23533 -3.22914 -3.22361 -3.22492 -3.22439
    -4.76469 -3.58964 -3.34482 -3.24468 -3.19921 -3.18519 -3.17821 -3.17333 -3.17548 -3.17452
    -4.62267 -3.52009 -3.29081 -3.19624 -3.15252 -3.13871 -3.13205 -3.12707 -3.12935 -3.12872
    -4.49286 -3.45782 -3.23979 -3.15110 -3.10890 -3.09557 -3.08939 -3.08488 -3.08664 -3.08621
    -4.37486 -3.39965 -3.19408 -3.10915 -3.06882 -3.05527 -3.04944 -3.04565 -3.04690 -3.04605
    -4.26819 -3.34616 -3.15051 -3.06940 -3.03085 -3.01803 -3.01221 -3.00889 -3.00964 -3.00869
    -4.17053 -3.29649 -3.11011 -3.03165 -2.99430 -2.98318 -2.97733 -2.97379 -2.97451 -2.97307
    -4.08071 -3.24911 -3.07133 -2.99695 -2.96003 -2.94972 -2.94354 -2.94078 -2.94132 -2.93989
    -3.99563 -3.20548 -3.03459 -2.96264 -2.92790 -2.91811 -2.91114 -2.90845 -2.90990 -2.90824
    -3.91563 -3.16304 -2.99971 -2.93031 -2.89711 -2.88724 -2.88084 -2.87847 -2.87921 -2.87750
    -3.84221 -3.12375 -2.96652 -2.89911 -2.86715 -2.85772 -2.85161 -2.84885 -2.84980 -2.84781
    -3.77251 -3.08564 -2.93433 -2.86985 -2.83878 -2.82876 -2.82353 -2.82043 -2.82229 -2.81977
    -3.70669 -3.04944 -2.90364 -2.84108 -2.81087 -2.80111 -2.79631 -2.79298 -2.79534 -2.79268
    -3.64283 -3.01447 -2.87327 -2.81320 -2.78364 -2.77467 -2.76968 -2.76659 -2.76874 -2.76654
    -3.58346 -2.98174 -2.84435 -2.78608 -2.75804 -2.74938 -2.74409 -2.74139 -2.74304 -2.74134
    -3.52735 -2.94919 -2.81657 -2.75985 -2.73273 -2.72397 -2.71954 -2.71671 -2.71790 -2.71691
    -3.47402 -2.91799 -2.78905 -2.73423 -2.70791 -2.69955 -2.69557 -2.69254 -2.69362 -2.69273
    -3.42135 -2.88734 -2.76215 -2.70993 -2.68383 -2.67598 -2.67238 -2.66864 -2.67058 -2.66890
    -3.37130 -2.85794 -2.73625 -2.68570 -2.66025 -2.65286 -2.64922 -2.64555 -2.64790 -2.64569
    -3.32273 -2.82906 -2.71120 -2.66212 -2.63756 -2.63046 -2.62671 -2.62297 -2.62529 -2.62299
    -3.27614 -2.80093 -2.68657 -2.63935 -2.61512 -2.60836 -2.60495 -2.60081 -2.60305 -2.60081
    -3.23171 -2.77373 -2.66249 -2.61667 -2.59304 -2.58671 -2.58340 -2.57918 -2.58130 -2.57910
    -3.18830 -2.74706 -2.63929 -2.59434 -2.57148 -2.56493 -2.56221 -2.55808 -2.56017 -2.55803
    -3.14676 -2.72050 -2.61633 -2.57203 -2.55011 -2.54423 -2.54169 -2.53739 -2.53943 -2.53728
    -3.10637 -2.69506 -2.59362 -2.55122 -2.52911 -2.52358 -2.52099 -2.51679 -2.51872 -2.51647
    -3.06680 -2.66997 -2.57135 -2.53013 -2.50855 -2.50320 -2.50072 -2.49621 -2.49822 -2.49588
    -3.02868 -2.64521 -2.54974 -2.50930 -2.48849 -2.48331 -2.48113 -2.47611 -2.47830 -2.47575
    -2.99079 -2.62118 -2.52824 -2.48863 -2.46840 -2.46339 -2.46142 -2.45625 -2.45833 -2.45645
    -2.95356 -2.59732 -2.50701 -2.46842 -2.44874 -2.44354 -2.44169 -2.43692 -2.43866 -2.43711
    -2.91810 -2.57406 -2.48602 -2.44839 -2.42909 -2.42427 -2.42236 -2.41759 -2.41962 -2.41793
    -2.88363 -2.55118 -2.46507 -2.42864 -2.40943 -2.40532 -2.40308 -2.39839 -2.40097 -2.39914
    -2.84966 -2.52854 -2.44463 -2.40880 -2.39037 -2.38620 -2.38393 -2.37950 -2.38226 -2.37998
    -2.81674 -2.50586 -2.42428 -2.38944 -2.37138 -2.36765 -2.36531 -2.36071 -2.36362 -2.36143
    -2.78373 -2.48365 -2.40423 -2.36993 -2.35262 -2.34902 -2.34649 -2.34206 -2.34513 -2.34276
    -2.75179 -2.46180 -2.38420 -2.35093 -2.33418 -2.33065 -2.32825 -2.32377 -2.32679 -2.32431
    -2.72053 -2.44016 -2.36457 -2.33209 -2.31586 -2.31199 -2.30968 -2.30548 -2.30892 -2.30606
    -2.68983 -2.41850 -2.34510 -2.31343 -2.29747 -2.29369 -2.29141 -2.28727 -2.29115 -2.28806
    -2.65954 -2.39707 -2.32537 -2.29457 -2.27898 -2.27537 -2.27324 -2.26941 -2.27279 -2.26989
    -2.62997 -2.37584 -2.30622 -2.27612 -2.26125 -2.25734 -2.25531 -2.25143 -2.25472 -2.25171
    -2.60065 -2.35443 -2.28680 -2.25766 -2.24316 -2.23934 -2.23729 -2.23348 -2.23662 -2.23383
    -2.57207 -2.33351 -2.26759 -2.23928 -2.22494 -2.22127 -2.21956 -2.21559 -2.21871 -2.21613
    -2.54415 -2.31244 -2.24811 -2.22054 -2.20696 -2.20326 -2.20154 -2.19791 -2.20096 -2.19831
    -2.51603 -2.29243 -2.22897 -2.20240 -2.18900 -2.18526 -2.18376 -2.18034 -2.18284 -2.18034
    -2.48873 -2.27192 -2.21004 -2.18408 -2.17088 -2.16740 -2.16608 -2.16250 -2.16473 -2.16243
    -2.46134 -2.25157 -2.19140 -2.16581 -2.15297 -2.14964 -2.14799 -2.14472 -2.14673 -2.14445
    -2.43422 -2.23123 -2.17243 -2.14772 -2.13477 -2.13199 -2.13020 -2.12686 -2.12896 -2.12670
    -2.40701 -2.21106 -2.15342 -2.12946 -2.11658 -2.11390 -2.11231 -2.10901 -2.11114 -2.10880
    -2.38047 -2.19044 -2.13459 -2.11116 -2.09874 -2.09614 -2.09428 -2.09141 -2.09294 -2.09071
    -2.35409 -2.17007 -2.11593 -2.09294 -2.08096 -2.07805 -2.07621 -2.07376 -2.07512 -2.07266
    -2.32778 -2.14956 -2.09715 -2.07439 -2.06252 -2.06028 -2.05799 -2.05590 -2.05738 -2.05466
    -2.30201 -2.12909 -2.07822 -2.05605 -2.04416 -2.04220 -2.04016 -2.03787 -2.03926 -2.03645
    -2.27657 -2.10914 -2.05929 -2.03731 -2.02620 -2.02399 -2.02196 -2.01985 -2.02100 -2.01837
    -2.25088 -2.08880 -2.04022 -2.01863 -2.00808 -2.00562 -2.00359 -2.00158 -2.00250 -2.00030
    -2.22586 -2.06809 -2.02102 -2.00004 -1.98956 -1.98698 -1.98521 -1.98338 -1.98413 -1.98251
    -2.20037 -2.04729 -2.00166 -1.98128 -1.97099 -1.96878 -1.96647 -1.96506 -1.96554 -1.96397
    -2.17515 -2.02683 -1.98209 -1.96249 -1.95267 -1.95018 -1.94794 -1.94632 -1.94668 -1.94532
    -2.14975 -2.00571 -1.96238 -1.94349 -1.93352 -1.93142 -1.92929 -1.92758 -1.92808 -1.92681
    -2.12432 -1.98477 -1.94267 -1.92407 -1.91455 -1.91240 -1.91050 -1.90831 -1.90899 -1.90792
    -2.09888 -1.96420 -1.92273 -1.90493 -1.89544 -1.89335 -1.89138 -1.88889 -1.88967 -1.88892
    -2.07349 -1.94261 -1.90229 -1.88520 -1.87618 -1.87380 -1.87174 -1.86955 -1.87004 -1.86953
    -2.04789 -1.92135 -1.88208 -1.86511 -1.85675 -1.85403 -1.85200 -1.84998 -1.85060 -1.84982
    -2.02227 -1.89971 -1.86154 -1.84511 -1.83675 -1.83433 -1.83182 -1.83020 -1.83065 -1.83010
    -1.99629 -1.87775 -1.84067 -1.82443 -1.81662 -1.81454 -1.81137 -1.81046 -1.81051 -1.81023
    -1.96985 -1.85528 -1.81940 -1.80355 -1.79606 -1.79359 -1.79076 -1.79001 -1.79017 -1.78981
    -1.94343 -1.83306 -1.79783 -1.78225 -1.77535 -1.77271 -1.77004 -1.76920 -1.76910 -1.76899
    -1.91681 -1.80993 -1.77581 -1.76049 -1.75381 -1.75151 -1.74877 -1.74825 -1.74784 -1.74783
    -1.88994 -1.78654 -1.75357 -1.73839 -1.73182 -1.72980 -1.72678 -1.72683 -1.72614 -1.72618
    -1.86262 -1.76265 -1.73044 -1.71539 -1.70963 -1.70776 -1.70439 -1.70469 -1.70428 -1.70388
    -1.83445 -1.73789 -1.70681 -1.69209 -1.68652 -1.68528 -1.68138 -1.68213 -1.68144 -1.68135
    -1.80567 -1.71301 -1.68278 -1.66846 -1.66294 -1.66163 -1.65771 -1.65892 -1.65796 -1.65781
    -1.77663 -1.68674 -1.65803 -1.64423 -1.63845 -1.63745 -1.63334 -1.63479 -1.63461 -1.63394
    -1.74674 -1.65968 -1.63258 -1.61901 -1.61355 -1.61248 -1.60835 -1.60998 -1.60978 -1.60894
    -1.71536 -1.63242 -1.60602 -1.59264 -1.58748 -1.58676 -1.58254 -1.58427 -1.58454 -1.58298
    -1.68347 -1.60390 -1.57848 -1.56597 -1.56085 -1.56029 -1.55563 -1.55760 -1.55781 -1.55588
    -1.65011 -1.57435 -1.55040 -1.53755 -1.53315 -1.53211 -1.52819 -1.53013 -1.53003 -1.52828
    -1.61525 -1.54381 -1.52107 -1.50866 -1.50430 -1.50333 -1.49928 -1.50124 -1.50094 -1.49969
    -1.57849 -1.51165 -1.48982 -1.47782 -1.47359 -1.47287 -1.46917 -1.47188 -1.47100 -1.46970
    -1.53944 -1.47746 -1.45779 -1.44536 -1.44204 -1.44125 -1.43737 -1.44045 -1.43885 -1.43807
    -1.49744 -1.44196 -1.42263 -1.41120 -1.40842 -1.40784 -1.40422 -1.40690 -1.40562 -1.40494
    -1.45163 -1.40418 -1.38583 -1.37498 -1.37288 -1.37218 -1.36907 -1.37181 -1.37017 -1.36902
    -1.40307 -1.36275 -1.34738 -1.33626 -1.33478 -1.33452 -1.33111 -1.33404 -1.33217 -1.33159
    -1.35032 -1.31804 -1.30580 -1.29421 -1.29378 -1.29380 -1.29002 -1.29278 -1.29152 -1.29131
    -1.29177 -1.26946 -1.25940 -1.24979 -1.24926 -1.24913 -1.24612 -1.24854 -1.24810 -1.24787
    -1.22812 -1.21716 -1.20881 -1.20013 -1.20024 -1.20116 -1.19877 -1.20050 -1.20025 -1.19971
    -1.15625 -1.15795 -1.15427 -1.14561 -1.14717 -1.14779 -1.14464 -1.14748 -1.14649 -1.14693
    -1.07498 -1.09147 -1.09111 -1.08588 -1.08702 -1.08870 -1.08464 -1.08838 -1.08612 -1.08749
    -0.98205 -1.01560 -1.01882 -1.01685 -1.01904 -1.02043 -1.01730 -1.02092 -1.01835 -1.02059
    -0.87127 -0.92745 -0.93572 -0.93764 -0.93988 -0.94238 -0.93808 -0.94212 -0.94056 -0.94285
    -0.73526 -0.82370 -0.83694 -0.84066 -0.84746 -0.84760 -0.84362 -0.85022 -0.84779 -0.84902
    -0.55717 -0.69092 -0.71269 -0.72234 -0.72786 -0.73059 -0.72758 -0.73336 -0.73117 -0.73005
    -0.29765 -0.50728 -0.54411 -0.56148 -0.56633 -0.57391 -0.57365 -0.57474 -0.57445 -0.57457
    0.17639 -0.20392 -0.27531 -0.30412 -0.31543 -0.32144 -0.32526 -0.32370 -0.32248 -0.32503
    0.67863  0.09636 -0.01706 -0.05932 -0.07659 -0.08627 -0.09165 -0.08749 -0.09298 -0.09147
    2.07835  0.76170  0.54385  0.44038  0.41799  0.40926  0.40584  0.39759  0.38714  0.38492];



Cvs = [.001 .005 .01:.01:.99 .995 .999];
Ts  = [10 25 50 100 250 500 1000 2500 5000 10000];


switch p
    case 0
        %load augdf_case1_cv;
        this_cv=augdf_case1_cv;
    case 1
        %load augdf_case2_cv;
        this_cv=augdf_case2_cv;
    case 2
        %load augdf_case4_cv;
        this_cv=augdf_case4_cv;
    case 3
        %load augdf_case4_cv
        this_cv=norminv(Cvs);
end


% Cvs by T.
% 1. Figure out which rows on the table
% 2. Compute the weights, linear
% 3. For each row compute the pval
if T>max(Ts)
    first_col=size(this_cv,2);
    second_col=first_col;
elseif T<min(Ts)
    first_col=size(this_cv,2);
    second_col=first_col;
else
    first_col=max(find(Ts<=T));
    second_col=min(find(Ts>=T));
end
if first_col~=second_col
    w = (Ts(second_col)-T)/(Ts(second_col)-Ts(first_col));
else
    w=0;
end
Cv1=this_cv(:,first_col);
Cv2=this_cv(:,second_col);
Cv=w*(Cv1)+(1-w)*Cv2;

first = max(find(tstat>Cv));
last = min(find(tstat<Cv));

if isempty(last)
    pval=1;
elseif isempty(first)
    pval=0;
else
    if first~=last
        wlast=1-(Cv(last)-tstat)/(Cv(last)-Cv(first));
    else
        wlast=1;
    end
    pval=(1-wlast)*Cvs(first)+wlast*Cvs(last);
end
pl=[3 7 12 92 97 101];%ismember(round(10000*Cvs)/10000,[.01 .05 .1 .9 .95 .99]);
critval = Cv(pl);


if isnan(pval) || pval<0
    keyboard
end
